/*:ja
 * @plugindesc 戦闘中立ち絵表示プラグイン
 * @author テリス
 *
 * @param pictureXpos
 * @desc 戦闘立ち絵グラを表示するX座標
 * @default 0
 *
 * @param pictureYpos
 * @desc 戦闘立ち絵グラを表示するY座標
 * @default 1
*/

(function() {
	
	var parameters = PluginManager.parameters('BattleStandIrast');
	var picXpos = Number(parameters['pictureXpos'] || 0);
	var picYpos = Number(parameters['pictureYpos'] || 0);
	
	/*=======================================================
		rpgManegerのBattleManager.selectNextCommandを上書き
	  =======================================================*/
	_BattleManager_selectNextCommand = BattleManager.selectNextCommand;
	BattleManager.selectNextCommand = function() 
	{
		do 
		{
			if (!this.actor() || !this.actor().selectNextCommand()) 
	        {
	        	$gameScreen.erasePicture(10);
	            this.changeActor(this._actorIndex + 1, 'waiting');
	            if (this._actorIndex >= $gameParty.size()) 
	            {
	                this.startTurn();
	                break;
	            }
	        }
	    } while (!this.actor().canInput());
	};

	/*======================================================
		rpgManegerのBattleManager.changeActorを上書き
	  ======================================================*/
	_BattleManager_changeActor = BattleManager.changeActor;
	BattleManager.changeActor = function(newActorIndex, lastActorActionState) 
	{
	    var lastActor = this.actor();
	    this._actorIndex = newActorIndex;
	    var newActor = this.actor();
	    if (lastActor) {
	        lastActor.setActionState(lastActorActionState);
	    }
	    
	    if (newActor) 
	    {
	    	var actorIdInfo = this.actor().actorId();
	    	
	    	 //現在コマンド選択中アクターから、gameDataのアクターId取得
	    	 if(actorIdInfo === 1)
	    	 	ArmarBreakChk( actorIdInfo );
	    	 	
	    	 else
	           	console.log("他");
	           	
	        newActor.setActionState('inputting');					//入力待ち
	        
	    }
	};
	
	/*======================================================
		rpgManegerのBattleManager._BattleManager_updateActionを上書き
	  ======================================================*/
	_BattleManager_updateAction = BattleManager.updateAction;
	BattleManager.updateAction = function() 
	{
	    var target = this._targets.shift();
	    if (target) {
	        this.invokeAction(this._subject, target);
	        if(target._actorId === 1)
	        {
	        	ArmarBreakChk( target._actorId );
	        }
	    } else {
	        this.endAction();
	        $gameScreen.erasePicture(10);
	    }
	};
	
	/*=======================================================
	            アーマーブレイク状態表示(コモンイベントからはできないため。)
	  =======================================================*/
	function ArmarBreakChk( actorIdInfo )
	{
		var itemNo =  $gameActors._data[actorIdInfo]._equips[3]._itemId;
		var equipArmorName;
		
		var strLoadActorPictureName = 'Actor' + actorIdInfo;
		
		//↓反転立ち絵名（作者仕様）↓
		strLoadActorPictureName = 'R_' + strLoadActorPictureName;
		//↑反転立ち絵名（作者仕様）↑
		 
		if(itemNo === 0)
		{
			equipArmorName = '';
		}
		else
		{
			equipArmorName = $dataArmors[itemNo].name;
		}
		//※全キャラ衣装変更がある場合、ここの処理を改造してください
		
		if( $gameActors._data[actorIdInfo].hp > ($gameActors._data[actorIdInfo].mhp / 2) )
		{
			if(equipArmorName == 'バニーの服' )
			{
				strLoadActorPictureName += '_3_1';				//衣装替えpicture名追加
			}
			else if(equipArmorName == '')
			{
				strLoadActorPictureName += '_4_1';				//裸picture名追加
			}
			else
			{
				strLoadActorPictureName += '_1_1';				//通常衣装picture名追加
			}
		}
		else
		{
			if(equipArmorName == 'バニーの服' )
			{
				strLoadActorPictureName += '_3_4';				//衣装替えpicture名追加
			}
			else if(equipArmorName == '')
			{
				strLoadActorPictureName += '_4_4';				//裸picture名追加
			}
			else
			{
				strLoadActorPictureName += '_2_4';				//通常衣装picture名追加
			}
			
		}
		$gameScreen.showPicture(10, strLoadActorPictureName, 0, picXpos, picYpos, 100, 100, 255, 0);
	}
})();
